#ifndef NODE_H
#define NODE_H

#include <iostream>

using namespace std;

// 前向声明 PQ 类，以便在 Node 中将其声明为友元
template <typename T> class PQ;

template <typename T>
class Node {
    // 声明 PQ<T> 为友元类，这样 PQ 就可以访问 Node 的私有成员
    friend class PQ<T>;

private:
    T value;
    Node<T>* parent;
    Node<T>* left;
    Node<T>* right;

public:
    // 构造函数
    Node(T v) : value(v), parent(nullptr), left(nullptr), right(nullptr) {}
};

#endif
