#include "BigInt.h"
#include <iostream>
#include <vector>
// #include <cassert>
using namespace std;

int main() {

    cout << "1. Equality & Comparison" << endl << "----------" << endl;

    // Constructors
    BigInt a(static_cast<size_t>(0));
    BigInt b(12345);
    BigInt c("00012345");
    BigInt d("9999999999999999999999999999");
    BigInt e(b); // copy

    cout << "a=0" << "\n";
    cout << "b=12345" << "\n";
    cout << "c=00012345" << "\n";
    cout << "d=9999999999999999999999999999" << "\n";
    cout << "e=b" << "\n";

    // Equality
    cout << "a==0:" << (a == BigInt(static_cast<size_t>(0))) << endl;
    cout << "b==c:" << (b == c) << endl;
    cout << "b==e:" << (b == e) << endl;
    cout << "b!=a:" << (b != a) << endl;

    // Comparisons
    cout << "a<b:" << (a < b) << endl;
    cout << "b>=c:" << (b >= c) << endl;
    cout << "d>b:" << (d > b) << endl;
    cout << "b<c:" << (b < c) << endl;
    cout << "b<=c:" << (b <= c) << endl;

    // Addition
    cout << "--------------------" << endl << "2. Addition" << endl << "----------" << endl;
    BigInt x("999");
    BigInt y("1");
    BigInt z = x + y; // 1000
    cout << "x=999,y=1"<<endl;
    cout << "z=x+y=" << z << "\n";

    BigInt aa("12345678901234567890");
    BigInt bb("98765432109876543210");
    cout << "aa=12345678901234567890,bb=98765432109876543210" << endl;
    BigInt cc = aa + bb; // 111111111011111111100
    cout << "aa+bb=" << cc << "\n";

    // +=
    BigInt m(static_cast<size_t>(0));
    cout << "m=0" << endl;
    m += BigInt("5");
    cout << "m+=5:" << m <<endl;
    m += BigInt("95");
    cout << "m+=95:" << m <<endl;

    // Multiplication
    cout << "--------------------" << endl << "3. Multiplication" << endl << "----------" << endl;
    BigInt p1("1234");
    BigInt p2("5678");
    BigInt p = p1 * p2; // 7006652
    cout << "p1=1234,p2=5678" <<endl;
    cout << "p1*p2:" << p << "\n";

    // *= with zero and one
    BigInt t(static_cast<size_t>(0));
    t *= BigInt("98765");
    cout << "t=0" << endl;
    cout << "t*=98765:" << t << endl;
    BigInt u("1");
    u *= BigInt("12345678901234567890");
    cout << "u=1" << endl;
    cout << "u*=12345678901234567890:" << u <<endl;

    cout << "--------------------" << endl << "All End.\n";
    return 0;
}
