#ifndef BIGINT_H
#define BIGINT_H

#include <cstddef>
#include <iostream>
using namespace std;

// BigInt: stores non-negative integers in base-10 as a char buffer of digits
// Fields required by assignment:
// - bool isZero
// - size_t len   : number of digits currently used (without leading zeros)
// - size_t size  : capacity of the buffer
// - char* s      : dynamically allocated buffer of digits (most significant first)
class BigInt {
public:
    // Constructors
    BigInt(size_t value = 0);                 // BigInt(size_t)
    BigInt(const char* str);                       // BigInt(const char*)
    BigInt(const BigInt& other);                   // BigInt(const BigInt&)

    // Destructor
    ~BigInt();

    // Assignment
    BigInt& operator=(const BigInt& other);

    // Arithmetic
    BigInt operator+(const BigInt& rhs) const;
    BigInt& operator+=(const BigInt& rhs);
    BigInt operator*(const BigInt& rhs) const;
    BigInt& operator*=(const BigInt& rhs);

    // Comparisons
    bool operator==(const BigInt& rhs) const;
    bool operator!=(const BigInt& rhs) const;
    bool operator<(const BigInt& rhs) const;
    bool operator<=(const BigInt& rhs) const;
    bool operator>(const BigInt& rhs) const;
    bool operator>=(const BigInt& rhs) const;

    // Output
    friend ostream& operator<<(ostream& os, const BigInt& x);

private:
    bool isZero;
    size_t len;
    size_t size;
    char* s; // digits stored most significant first, each '0'..'9'

    // Helpers
    void init_with_zero();
    void ensure_capacity(size_t cap);
    void normalize(); // remove leading zeros and set isZero appropriately
};

#endif // BIGINT_H
