# Canvas 坦克大战（HTML5 Canvas Tank Game）

一个基于 HTML5 Canvas 的经典坦克大战小游戏，支持 1P/2P 本地双人，含多张地图、道具、爆炸与音效等要素。项目为纯前端静态页面，无需构建即可本地运行。

## 功能特性
- 双人模式：菜单可选择 1P 或 2P 开始游戏。
- 21 张关卡：循环轮播，过关后自动进入下一关。
- 敌军生成：最多 20 个敌军（可在代码中调整），分批出现并带有简单 AI。
- 多类地形：水泥墙、铁墙、草丛、水面、冰面与基地（家）。
- 道具系统：加命、冰冻敌人、基地加固、全屏炸弹、护盾等（详见下文）。
- 多层画布：地图、坦克、草、覆盖层分层渲染，带爆炸动画与音效。

## 运行方式（本地）
建议在本地开启静态服务器运行，以避免浏览器对音频/资源的本地文件限制。

- 进入项目目录：`tank/`
- 方式一：Python 3 内置服务器（macOS 自带）
```bash
cd /Users/yanqiansong/Downloads/canvas-special-master/tank
python3 -m http.server 5500
```
然后打开浏览器访问：http://localhost:5500/

- 方式二：Node http-server（如已安装 Node）
```bash
npm i -g http-server
cd /Users/yanqiansong/Downloads/canvas-special-master/tank
http-server -p 5500
```
访问：http://localhost:5500/

提示：若没有声音，先进行一次键盘操作或点击页面，或在浏览器设置中允许站点自动播放音频。

## 操作说明
- 菜单：上下方向键选择 1P/2P，回车开始。
- 玩家1：W/A/S/D 移动，空格 射击。
- 玩家2：方向键 移动，Enter 射击。
- 关卡切换：N 下一关，P 上一关（调试/体验用）。

上述按键在 `index.html` 与 `js/keyboard.js` 中定义。

## 玩法规则
- 胜利条件：本关所有敌军被消灭（生成完且场上清空）。
- 失败条件：基地（家）被击毁，或双方生命值均归零。
- 复活：玩家被击毁后若仍有生命值，会在出生点复活且短时间无敌。

## 道具说明（`js/prop.js`）
道具随机出现在地图上，被玩家接触后生效：
- 加命：玩家生命 +1。
- 冰冻：短时间内令所有敌军停止行动。
- 基地加固：用铁墙临时加固基地四周。
- 全屏炸弹：立刻摧毁当前场上所有敌军。
- 护盾：给予玩家短时间无敌保护。
- 说明：代码中的第 4 类道具目前未实现额外效果（占位）。

## 目录结构
```
index.html
css/
  default.css
images/
  menu.gif, tankAll.gif, ...
audio/
  start.mp3, move.mp3, attack.mp3, ...
js/
  main.js            # 主循环、状态机、关卡切换
  stage.js           # 关卡开始过场/遮罩动画
  map.js             # 地图绘制与右侧信息区、生命/敌军显示
  level.js           # 21 张关卡的二维数组
  tank.js            # 玩家/敌军坦克与 AI、复活
  bullet.js          # 子弹移动/碰撞/爆炸
  Collision.js       # 地图/坦克/子弹碰撞检测
  prop.js            # 道具生成与效果
  crackAnimation.js  # 爆炸特效
  num.js             # 右侧数字绘制
  const.js           # 全局常量、资源位置信息与音频
  keyboard.js        # 键值映射
  Helper.js          # Array 辅助方法（remove/contain）
  jquery.min.js
```

## 技术栈
- HTML5 Canvas 多层渲染（墙体/坦克/草地/覆盖层）。
- 原生 JavaScript + jQuery（事件与 DOM 简化）。
- 精灵图切片渲染与逐帧动画，简单音频效果。

## 可配置项
在 `js/main.js` 与 `js/const.js` 中可调整：
- `SCREEN_WIDTH` / `SCREEN_HEIGHT`：画布尺寸。
- `maxEnemy` / `maxAppearEnemy`：每关总敌军数与同屏出现上限。
- 资源路径、音量策略等。

## 已知注意点
- 不同浏览器对自动播放音频的策略不同；若无声，请先按键或开启自动播放。
- 直接用文件协议打开（file://）可能导致音频或资源加载异常，建议用本地服务器。