# 五子棋（HTML5 Canvas，人机对战）

一个基于原生 JavaScript 与 HTML5 Canvas 实现的 15×15 五子棋小游戏，支持玩家（黑棋）对战简单启发式 AI（白棋）。开箱即用，直接双击 `index.html` 即可游玩。

## 功能特性
- 15×15 标准棋盘，固定画布尺寸 `450×450`。
- 玩家（黑棋）先行，点击网格交点即可落子。
- 预计算 572 种连五“赢法”，快速胜负判断。
- 简单启发式 AI：使用攻防评分（`myScore` / `pcScore`）选择下法。
- 结束弹窗提示胜负结果。

## 目录结构
```
five-chess/
├─ index.html
├─ css/
│  ├─ FiveChess.css
│  └─ myreset.css
└─ js/
   ├─ FiveChess.js
   └─ html5.js   # 仅旧版 IE 条件注释下使用
```

## 快速开始
方式一：直接打开
- 双击 `index.html`，用现代浏览器打开即可游玩。

方式二：本地静态服务器（推荐开发调试）
```bash
# 在项目根目录启动一个本地服务器
python3 -m http.server 8000
# 浏览器访问
open http://localhost:8000/index.html
```

> 说明：项目为纯静态资源，无需构建或依赖安装。

## 玩法说明
- 黑棋（玩家）先手，点击棋盘网格交点完成落子。
- 白棋（AI）随后自动应手。
- 任意一方先在横/竖/斜任一方向连成 5 子即获胜。
- 对局结束后会弹窗提示，刷新页面即可重新开始。

## 实现要点
- 棋盘绘制：`DrawChessBoard()` 使用 Canvas 画 15×15 网格。
- 落子渲染：`oneStep(i, j, me)` 绘制黑/白棋子（径向渐变）。
- 赢法统计：`CountallWins()` 预计算所有可能的 5 连组合（共 572 种）。
- AI 策略：`AI()` 为空位打分并选择最大分：
  - 进攻（玩家已成势）加分：`200 / 400 / 1000 / 10000`
  - 防守（AI 已成势）加分：`220 / 420 / 1100 / 20000`

主要变量与数据结构（节选）：
- `has[15][15]`：棋盘占位，0=空，1=玩家，2=AI。
- `allwins[15][15][count]`：位置-赢法三维布尔数组。
- `mythiswin[count]`、`pcthiswin[count]`：双方在每种赢法上的已连子数。

## 自定义与扩展
- 画布与格子尺寸：
  - 画布在 `index.html` 中设置为 `450×450`，每格 30px，棋子半径 13。
  - 若需缩放棋盘，请同步调整相关坐标与绘制逻辑。
- AI 权重：
  - 在 `AI()` 中可修改进攻/防守加分以改变倾向（更保守或更激进）。
- 重新开始/悔棋：
  - 当前无按钮；可新增“重开/悔棋”按钮并在逻辑中重置 `has`、`over` 等状态。
- 规则拓展：
  - 目前未实现禁手（如长连、三三、四四）判定，可按需要补充。

## 已知限制
- 无悔棋/复盘功能；可通过刷新页面重新开始。
- 暂不支持人人对战模式（仅人机对战）。
- 无禁手判定；不含开局/让子等高级规则。
- 适配以桌面浏览器为主，移动端未专项优化。

## 兼容性
- 现代浏览器（Chrome/Edge/Firefox/Safari）可直接运行。
- `index.html` 中包含旧版 IE 的 HTML5 补丁（条件注释），仅在需要时加载 `js/html5.js`。

## 文件说明
- `index.html`：入口页面与 Canvas 容器。
- `js/FiveChess.js`：棋盘绘制、落子、胜负判断与 AI 逻辑。
- `css/FiveChess.css`、`css/myreset.css`：样式与重置。
- `js/html5.js`：旧版 IE 的 HTML5 标签支持（无需现代浏览器）。

## 致谢
- 页面 `meta` 中作者信息：白小明（“一个迷醉技术与生活的人”）。
